package cn.xfyun.example;

import cn.xfyun.example.util.AuthUtil;
import cn.xfyun.example.util.AvatarWsUtil;
import com.alibaba.fastjson2.JSONObject;

import java.io.*;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;


public class Main extends AvatarWsUtil {
    private static final String avatarUrl = "xxxxxx";//API Endpoint
    private static final String apiKey = "xxx"; //Please go to the Interaction Platform - Interface Services to obtain it.
    private static final String apiSecret = "xxx"; //Please go to the Interaction Platform - Interface Services to obtain it.
    private static final String appId = "xxx"; //Please go to the Interaction Platform - Interface Services to obtain it.
    private static final String avatarId = "110117005"; //Please go to the Interaction Platform - Interface Services to obtain it.
    public static final String TTE = "UTF8"; // Minor languages must use UNICODE encoding as the value
    // Speaker parameters. Go to Console - My Applications - Speech Synthesis - Add a trial or purchase a speaker. After adding, the parameter values of the speaker will be displayed. If you try to use a speaker that hasn't been added for the trial, error 11200 will occur.
    public static final String VCN = "x4_lingxiaoying_assist";//Please go to the Interaction Platform - API Services - Sound List to obtain it.



    public static void main(String[] args) throws Exception {
        String requestUrl = AuthUtil.assembleRequestUrl(avatarUrl, apiKey, apiSecret);
        System.out.println("requestUrl:"+requestUrl);
        long l = System.currentTimeMillis();
        System.out.println("Timestamp："+l);
        AvatarWsUtil avatarWsUtil = new AvatarWsUtil(requestUrl);
        //Sending String Protocol
        System.out.println("Start sending the start protocol");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        try{
            avatarWsUtil.start(buildStartRequest(), countDownLatch);
        }catch (Exception e){
            e.printStackTrace();
        }
        countDownLatch.await();
        //Send a ping frame, and after start, send a ping heartbeat every 5 seconds to maintain the WebSocket connection.
        Timer timer = new Timer();
        CompletableFuture.runAsync(()->{
            TimerTask timeoutTask = new TimerTask() {
                @Override
                public void run() {
                    avatarWsUtil.send(buildPingRequest());
                }
            };
            timer.scheduleAtFixedRate(timeoutTask, 0,5000);
        });

        Thread.sleep(15000);
        //text-driven
        avatarWsUtil.send(buildTextRequest("This is text-driven; text-driven does not involve understanding."));
        Thread.sleep(10000);


        //Audio-driven, does not comprehend the content, directly plays the audio, only performs lip-syncing.
        //In an audio file, the value of the status parameter is: 0-1-1-1-……-1-1-1-2. It starts from 0, transitions through 1, and ends with 2.
        //Don't make the byte array too small, otherwise it will feel laggy.
        //Thread.sleep(100) here is to simulate an interval; it's best to have an interval of 40-100ms.
        File audio = new File("src/main/java/cn/xfyun/example/util/Test.pcm");
        try(InputStream inputStream = new FileInputStream(audio)) {
            byte[] bytes = new byte[1024*10];
            int len = 0;
            int status = 0;
            String requestId = UUID.randomUUID().toString();
            while ((len = inputStream.read(bytes)) != -1) {
                System.out.println("status="+status);
                if(len == -1){
                    status = 2;
                }
                Thread.sleep(50);
                String audioData = Base64.getEncoder().encodeToString(Arrays.copyOfRange(bytes, 0, len));
                avatarWsUtil.send(buildAudioRequest(requestId, status, audioData));
                Arrays.fill(bytes, (byte) 0);
                status = 1;
            }
            avatarWsUtil.send(buildAudioRequest(requestId,2,"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA="));
        }catch (Exception e){
            e.printStackTrace();
        }

//        avatarWsUtil.close();
//        timer.cancel();
//        System.exit(0);
    }

    //Start Protocol
    private static JSONObject buildStartRequest() {
        JSONObject header = new JSONObject()
                .fluentPut("app_id", appId)
                .fluentPut("ctrl", "start")//Control parameters
                .fluentPut("request_id", UUID.randomUUID().toString())
                .fluentPut("scene_id","77213753883627520");//Please go to the Interactive Platform - API Services to obtain it by entering the 'API Service ID'.

        JSONObject parameter = new JSONObject()
                .fluentPut("avatar", new JSONObject()
                        .fluentPut("avatar_id", avatarId)// (Required) Authorized image resource ID. Please obtain it from the Interaction Platform - API Services - Image List.
                        .fluentPut("width",720)// Video Resolution: Width
                        .fluentPut("height",1280)// Video Resolution: Height
                        .fluentPut("stream", new JSONObject()
                                .fluentPut("protocol", "xrtc")//(Required) Video protocol, currently only xRTC supports transparent backgrounds and requires the alpha parameter to be set to 1.
                                .fluentPut("fps",25)// (Optional) Video refresh rate. The higher the value, the smoother the playback. The value range is 0-25, with 25 as the default.
                                .fluentPut("bitrate",5000)//(Optional) Video bitrate: the higher the value, the clearer the video, but the higher the network requirement.
                                .fluentPut("alpha",0)))//(Optional) Transparent background, requires protocol=xrtc, 0 = off, 1 = on
                .fluentPut("tts",new JSONObject()
                        .fluentPut("speed",50)// Speech speed: [0,100], default 50
                        .fluentPut("vcn",VCN))//(Required) The ID of the authorized audio resource. Please obtain it from Interaction Platform - API Services - Audio List.
                .fluentPut("subtitle",new JSONObject()//Note: Since the subtitles are sent from the cloud, it is not possible to know exactly which word the virtual person is reading, nor can playback be paused or resumed.
                        .fluentPut("subtitle",0)//0 Off, 1 On
                        .fluentPut("font_color","#FF0000")//Font color
                        .fluentPut("font_size",10)//Font size, value range: 1-10
                        .fluentPut("position_x",0)//The subtitles can move left and right, and must be used together with width and height.
                        .fluentPut("position_y",0)//To move the subtitles up and down, you must provide width and height together.
                        .fluentPut("width",100)//Subtitle Width
                        .fluentPut("height",100));//Subtitle Height

        return new JSONObject().fluentPut("header",header).fluentPut("parameter",parameter);
    }

//Text-Driven Protocol
    private static JSONObject buildTextRequest(String text) {
        JSONObject header = new JSONObject()
                .fluentPut("app_id",appId)
                .fluentPut("ctrl","text_driver")
                .fluentPut("request_id", UUID.randomUUID().toString());

        JSONObject parameter = new JSONObject()
                .fluentPut("avatar_dispatch",new JSONObject()
                        .fluentPut("interactive_mode",0))
                .fluentPut("tts",new JSONObject()
                        .fluentPut("vcn",VCN)//Synthetic Voice
                        .fluentPut("speed",50)
                        .fluentPut("pitch",50)
                        .fluentPut("volume",50))
                .fluentPut("air",new JSONObject()
                        .fluentPut("air",0)//Enable automatic actions? 0 for off / 1 for on
                        .fluentPut("add_nonsemantic",0));//是Whether to enable non-directional actions: 0 for off, 1 for on (effective only when nlp=true). The virtual human will perform actions without intentional direction.

        JSONObject payload = new JSONObject()
                .fluentPut("text",new JSONObject()
                        .fluentPut("content",text));
        return new JSONObject().fluentPut("header",header).fluentPut("parameter",parameter).fluentPut("payload",payload);
    }


//Heartbeat, keep-alive protocol
    private static JSONObject buildPingRequest() {
        JSONObject header = new JSONObject()
                .fluentPut("app_id",appId)
                .fluentPut("ctrl","ping")
                .fluentPut("request_id", UUID.randomUUID().toString());
        return new JSONObject().fluentPut("header",header);
    }


    //Audio Driver Protocol
    private static JSONObject buildAudioRequest(String requestid,int status,String content ) throws IOException {
        JSONObject header = new JSONObject()
                .fluentPut("app_id",appId)
                .fluentPut("ctrl","audio_driver")
                .fluentPut("request_id",requestid);
        JSONObject parameter = new JSONObject()
                .fluentPut("avatar_dispatch",new JSONObject()
                        .fluentPut("audio_mode",0));
        JSONObject payload = new JSONObject()
                .fluentPut("audio",new JSONObject()
//                        .fluentPut("encoding","pcm")
//                        .fluentPut("sample_rate",16000)
//                        .fluentPut("channels",1)
//                        .fluentPut("bit_depth",16)//Audio Sample Bit Depth
                        .fluentPut("status",status)//Data Status
//                        .fluentPut("seq",1)//Data Serial Number
                        .fluentPut("audio",content));
//                        .fluentPut("frame_size",0));//Frame size

        return new JSONObject().fluentPut("header",header).fluentPut("parameter",parameter).fluentPut("payload",payload);
    }




    //Individual command protocol
    private static JSONObject buildCmdRequest(String dongzuo){
        JSONObject header = new JSONObject()
                .fluentPut("app_id",appId)
                .fluentPut("ctrl","cmd")
                .fluentPut("request_id",UUID.randomUUID().toString());
        JSONObject payload = new JSONObject()
                .fluentPut("cmd_text",new JSONObject()
                        .fluentPut("avatar",new JSONObject()
                                .fluentPut("type","action")
                                .fluentPut("value","A_RLH_puzzle_0")));
        return new JSONObject().fluentPut("header",header).fluentPut("payload",payload);
    }

    //Reset (Interrupt) Protocol
    private static JSONObject buildResetRequest(){
        JSONObject header = new JSONObject()
                .fluentPut("app_id",appId)
                .fluentPut("ctrl","reset")
                .fluentPut("request_id",UUID.randomUUID().toString());
        return new JSONObject().fluentPut("header",header);
    }
    //stop protocol
    private static JSONObject buildStopRequest(){
        JSONObject header = new JSONObject()
                .fluentPut("app_id",appId)
                .fluentPut("ctrl","stop")
                .fluentPut("request_id",UUID.randomUUID().toString());
        return new JSONObject().fluentPut("header",header);
    }
}
